/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.TagGenerator;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.loading.DatagenModLoader;

public class RechiseledBlockTagsGenerator
extends TagGenerator {
    private static final Supplier<MultiPackResourceManager> SERVER_DATA_FIELD;
    private static final Gson GSON;
    private static final List<Pair<Supplier<Block>, Set<ResourceLocation>>> TAGS;
    private static final List<Pair<Supplier<Block>, Supplier<Block>>> TAGS_FROM_BLOCKS;
    private final Map<ResourceLocation, List<Block>> loadedTags = Maps.newHashMap();

    public static void addBlockTags(Supplier<Block> blockSupplier, Set<ResourceLocation> tags) {
        TAGS.add((Pair<Supplier<Block>, Set<ResourceLocation>>)Pair.of(blockSupplier, tags));
    }

    public static void addBlockTagsFromOtherBlock(Supplier<Block> blockSupplier, Supplier<Block> otherBlock) {
        TAGS_FROM_BLOCKS.add((Pair<Supplier<Block>, Supplier<Block>>)Pair.of(blockSupplier, otherBlock));
    }

    public RechiseledBlockTagsGenerator(ResourceCache cache) {
        super("rechiseled", cache);
    }

    public void generate() {
        TAGS_FROM_BLOCKS.stream().map(pair -> pair.mapRight(this::getTagsForBlock)).forEach(TAGS::add);
        TAGS.stream().flatMap(pair -> ((Set)pair.right()).stream().map(tag -> Pair.of((Object)((Supplier)pair.left()), (Object)tag))).map(pair -> pair.mapLeft(Supplier::get)).forEach(pair -> this.blockTag((ResourceLocation)pair.right()).add((Object)((Block)pair.left())));
    }

    private Set<ResourceLocation> getTagsForBlock(Supplier<Block> block) {
        return Stream.of(BlockTags.f_144280_, BlockTags.f_144281_, BlockTags.f_144282_, BlockTags.f_144283_, BlockTags.f_144286_, BlockTags.f_144285_, BlockTags.f_144284_).map(TagKey::f_203868_).filter(tag -> this.loadVanillaTag((ResourceLocation)tag).contains(block.get())).collect(Collectors.toSet());
    }

    private List<Block> loadVanillaTag(ResourceLocation location) {
        if (this.loadedTags.containsKey(location)) {
            return this.loadedTags.get(location);
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        MultiPackResourceManager resourceManager = SERVER_DATA_FIELD.get();
        try {
            for (Resource resource : resourceManager.m_7396_(new ResourceLocation(location.m_135827_(), "tags/blocks/" + location.m_135815_() + ".json"))) {
                try {
                    InputStream stream = resource.m_6679_();
                    try {
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
                        JsonArray array = json.getAsJsonArray("values");
                        for (JsonElement element : array) {
                            String name = element.getAsString();
                            if (name.charAt(0) == '#') {
                                blocks.addAll(this.loadVanillaTag(new ResourceLocation(name.substring(1))));
                                continue;
                            }
                            ResourceLocation registryName = new ResourceLocation(name);
                            Block block = (Block)Registries.BLOCKS.getValue(registryName);
                            if (block == null) {
                                throw new JsonParseException("Unknown block '" + registryName + "' in '" + location + "'");
                            }
                            blocks.add(block);
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.loadedTags.put(location, blocks);
        return blocks;
    }

    static {
        try {
            Field existingFileHelper = DatagenModLoader.class.getDeclaredField("existingFileHelper");
            existingFileHelper.setAccessible(true);
            Field serverData = ExistingFileHelper.class.getDeclaredField("serverData");
            serverData.setAccessible(true);
            SERVER_DATA_FIELD = () -> {
                try {
                    return (MultiPackResourceManager)serverData.get(existingFileHelper.get(null));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        GSON = new GsonBuilder().create();
        TAGS = new ArrayList<Pair<Supplier<Block>, Set<ResourceLocation>>>();
        TAGS_FROM_BLOCKS = new ArrayList<Pair<Supplier<Block>, Supplier<Block>>>();
    }
}

